% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_functions.R
\name{imf_metadata}
\alias{imf_metadata}
\title{Access meta data for specific country-series}
\usage{
imf_metadata(database_id, indicator, country = "all", start = 2000,
  end = 2013, return_raw = FALSE)
}
\arguments{
\item{database_id}{character string database ID. Can be found using
\code{\link{imf_ids}}.}

\item{indicator}{character string of the indicator's ID.
These can be found using \code{\link{imf_codes}}.}

\item{country}{character string or character vector of ISO two letter
country codes identifying the countries for which you would like to
download the indicator metadata for.
See \url{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}. If
\code{country = 'all'} then all available countries will be downloaded.}

\item{start}{year for which you would like to start gathering the data.}

\item{end}{year for which you would like to end gathering the data.}

\item{return_raw}{logical. Whether to return the raw metadata
a data frame with just the requested data metadata.}
}
\description{
Access meta data for specific country-series
}

