% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_annotations.R
\name{parse_annotations}
\alias{parse_annotations}
\title{parse image annotations}
\usage{
parse_annotations(annotations)
}
\arguments{
\item{annotations}{An annotation object created with \code{\link[imgrec]{get_annotations}}.}
}
\value{
A list containing data frames for each feature:
\describe{
  \item{labels}{label annotations}
  \item{web_labels}{web label annotations}
  \item{web_similar}{similar web images}
  \item{web_match_partial}{partial matching web images}
  \item{web_match_full}{full matching web images}
  \item{web_match_pages}{matching web pages}
  \item{faces}{face annotations}
  \item{objects}{object annotations}
  \item{logos}{logo annotations}
  \item{landmarks}{landmark annotations}
  \item{full_text}{full text annotation}
  \item{safe_serarch}{safe search annotation}
  \item{colors}{dominant color annotations}
  \item{crop_hints}{crop hints for ratios 0.8/1.0/1.2}
}
}
\description{
Parses the annotations and converts most of the features to data frames. Also stores the corresponding image identifiers for each feature as \code{'img_id'}
}
\examples{
\dontrun{
# initialize api credentials
gvision_init()

# annotate images
finn_image <- 'https://upload.wikimedia.org/wikipedia/en/2/2a/Finn-Force_Awakens_\%282015\%29.png'
sw_image <- 'https://upload.wikimedia.org/wikipedia/en/8/82/Leiadeathstar.jpg'
padme_image <- 'https://upload.wikimedia.org/wikipedia/en/e/ee/Amidala.png'

results <- get_annotations(images = c(finn_image, sw_image, padme_image),
                           features = 'all', max_res = 10, mode = 'url')
# parse annotations
img_data <- parse_annotations(results)

# available feature data frames
names(img_data)
  }
  
}
