% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_daily.R
\name{hydro_daily}
\alias{hydro_daily}
\title{Daily hydrological data}
\usage{
hydro_daily(year, coords = FALSE, station = NULL, col_names = "short", ...)
}
\arguments{
\item{year}{vector of years (e.g., 1966:2000)}

\item{coords}{add coordinates of the stations (logical value TRUE or FALSE)}

\item{station}{name or ID of hydrological station(s).
It accepts names (characters in CAPITAL LETTERS) or stations' IDs (numeric)}

\item{col_names}{three types of column names possible: "short" - default, values with shorten names, "full" - full English description, "polish" - original names in the dataset}

\item{...}{other parameters that may be passed to the 'shortening' function that shortens column names}
}
\description{
Downloading daily hydrological data from the danepubliczne.imgw.pl collection
}
\examples{
\donttest{
  daily <- hydro_daily(year = 2000)
  head(daily)
}

}
