% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_theory.R
\name{entropy}
\alias{entropy}
\alias{kl_div}
\alias{js_div}
\alias{cross_entropy}
\title{Information measures}
\usage{
entropy(.data, .base = 2, .norm = FALSE, .do.norm = NA, .laplace = 1e-12)

kl_div(.alpha, .beta, .base = 2, .do.norm = NA, .laplace = 1e-12)

js_div(.alpha, .beta, .base = 2, .do.norm = NA, .laplace = 1e-12, .norm.entropy = FALSE)

cross_entropy(.alpha, .beta, .base = 2, .do.norm = NA,
              .laplace = 1e-12, .norm.entropy = FALSE)
}
\arguments{
\item{.data}{Numeric vector. Any distribution.}

\item{.base}{Numeric. A base of logarithm.}

\item{.norm}{Logical. If TRUE then normalise the entropy by the maximal value of the entropy.}

\item{.do.norm}{If TRUE then normalise input distributions to make them sum up to 1.}

\item{.laplace}{Numeric. A value for the laplace correction.}

\item{.alpha}{Numeric vector. A distribution of some random value.}

\item{.beta}{Numeric vector. A distribution of some random value.}

\item{.norm.entropy}{Logical. If TRUE then normalise the resultant value by the average entropy of input distributions.}
}
\value{
A numeric value.
}
\description{
Compute information-based estimates and distances.
}
\examples{
P <- abs(rnorm(10))
Q <- abs(rnorm(10))
entropy(P)
kl_div(P, Q)
js_div(P, Q)
cross_entropy(P, Q)
}
\concept{utility_public}
