% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_processing.R
\name{find_peaks}
\alias{find_peaks}
\title{Find peaks in a signal}
\usage{
find_peaks(data, vector, min_height = 1.3, min_dist = 0.4)
}
\arguments{
\item{data}{An \code{impactr_data} object, as obtained with
\link[=read_acc]{read_acc()}.}

\item{vector}{A character string indicating in which acceleration vector to
find the peaks. Can be "resultant", "vertical" or "all".}

\item{min_height}{The minimum height of the peaks (in \emph{g}).}

\item{min_dist}{The minimum horizontal distance between peaks (in seconds).}
}
\value{
An object of class \code{impactr_peaks} with the peaks magnitude
stored in the columns.
}
\description{
Find peaks in the acceleration signal.
}
\details{
The default values of the filter parameters are matching the filter
used in the paper by Veras et al. that developed the mechanical loading
prediction equations (see References).
When the \code{vector} parameter is set to "all", there may contain
\code{NA} values in the \code{resultant_peak_acc} and/or
\code{vertical_peak_acc} at the timestamps in which a peak value for that
vector could not be identified.

The default values of \code{min_height} and \code{min_dist} are
matching the criteria used in the paper by Veras et al. that developed the
mechanical loading prediction equations (see References)
}
\examples{
data <- read_acc(impactr_example("hip-raw.csv"))
data <- use_resultant(data)
find_peaks(data, vector = "resultant")
}
\references{
\itemize{
\item Veras L, Diniz-Sousa F, Boppre G, Devezas V, Santos-Sousa H, Preto J,
Machado L, Vilas- Boas JP, Oliveira J, Fonseca H. Accelerometer-based
prediction of skeletal mechanical loading during walking in normal weight
to severely obese subjects. Osteoporosis International. 2020. 31(7):1239-
1250. \doi{https://doi.org/10.1007/s00198-020-05295-2}.
}
}
