% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPlayerProfileScores.R
\name{getPlayerProfileScores}
\alias{getPlayerProfileScores}
\title{Return a dataframe that contains all player profile scores for a given
iteration ID}
\usage{
getPlayerProfileScores(iteration, positions, token)
}
\arguments{
\item{iteration}{'IMPECT' iteration ID}

\item{positions}{list of position names. Must be one of:   "GOALKEEPER",
"LEFT_WINGBACK_DEFENDER", "RIGHT_WINGBACK_DEFENDER", "CENTRAL_DEFENDER",
"DEFENSE_MIDFIELD", "CENTRAL_MIDFIELD", "ATTACKING_MIDFIELD", "LEFT_WINGER",
"RIGHT_WINGER", "CENTER_FORWARD"}

\item{token}{bearer token}
}
\value{
a dataframe containing the player profilescores aggregated per player
for the given iteration ID and list of positions
}
\description{
Return a dataframe that contains all player profile scores for a given
iteration ID
}
\examples{
# Toy example: this will error quickly (no API token)
try(player_profile_scores <- getPlayerProfileScores(
  iteration = 0,
  positions = c("INVALID_POSITION_1", "INVALID_POSITION_2"),
  token = "invalid"
))

# Real usage: requires valid Bearer Token from `getAccessToken()`
\dontrun{
player_profile_scores <- getPlayerProfileScores(
  iteration = 1004,
  positions = c("CENTRAL_DEFENDER", "DEFENSE_MIDFIELD"),
  token = "yourToken"
)
}
}
