#' Insurance Company Benchmark (COIL 2000) Data Set 
#' 
#' This data set used in the CoIL 2000 Challenge contains information on customers of an insurance company. 
#' The data consists of 86 variables and includes product usage data and socio-demographic data. Detailed
#' information, please refer to the Source. For imputation study, this dataset can be treated as a mixed-type
#' data.
#' 
#' \itemize{
#'  \item V1. a numeric variable
#'  \item V2. a categorical variable
#'  \item ...
#'  }
#' 
#' @source \url{http://archive.ics.uci.edu/ml/datasets/Insurance+Company+Benchmark+(COIL+2000)}
#' @references P. van der Putten and M. van Someren (eds). CoIL Challenge 2000: 
#' The Insurance Company Case. Published by Sentient Machine Research, Amsterdam. 
#' Also a Leiden Institute of Advanced Computer Science Technical Report 2000-09. June 22, 2000. 
#' @docType data
#' @keywords datasets
#' @format A data frame with 266 rows and 23 variables
#' @name tic
NULL