% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.kalman.R
\name{na.kalman}
\alias{na.kalman}
\title{Missing Value Imputation by Kalman Smoothing and State Space Models}
\usage{
na.kalman(x, model = "StructTS", smooth = TRUE, nit = -1, ...)
}
\arguments{
\item{x}{Numeric Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object in which missing values shall be replaced}

\item{model}{Model to be used. With this parameter the State Space Model (on which KalmanSmooth is performed) can be chosen. Accepts the following input:
\itemize{
   \item{"auto.arima" - For using the state space representation of arima model (using \link[forecast]{auto.arima})}
   \item{"StructTS" - For using a structural model fitted by maximum likelihood (using \link[stats]{StructTS}) }
   }
 
 For both auto.arima and StructTS additional parameters for model building can be given with the \dots parameter  
   
 Additionally it is also possible to use a user created state space model (See code Example 5). This state space model could for example be obtained from another
 R package for structural time series modeling. Furthermore providing the state space representation of a arima model from \link[stats]{arima}
 is also possible. But it is important to note, that user created state space models must meet the requirements specified under \link[stats]{KalmanLike}. This means the user supplied state space model has to be in form of a list with at least components T, Z, h , V, a, P, Pn. 
 (more details under \link[stats]{KalmanLike})}

\item{smooth}{if \code{TRUE} - \code{\link[stats]{KalmanSmooth}} is used for estimation, if \code{FALSE} - \code{\link[stats]{KalmanRun}} is used. Since KalmanRun is often considered extrapolation KalmanSmooth is usually the better choice for imputation.}

\item{nit}{Parameter from Kalman Filtering (see \link[stats]{KalmanLike}). Usually no need to change from default.}

\item{...}{Additional parameters to be passed through to the functions that build the State Space Models (\link[stats]{StructTS} or \link[forecast]{auto.arima}).}
}
\value{
Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object (dependent on given input at parameter x)
}
\description{
Uses Kalman Smoothing on structural time series models (or on the state space representation of an arima model) for imputation.
}
\details{
The KalmanSmoother used in this function is \code{\link[stats]{KalmanSmooth}}.
It operates either on a \code{Basic Structural Model} obtained by \code{\link[stats]{StructTS}} or
the state space representation of a ARMA model obtained by \code{\link[forecast]{auto.arima}}.

For an detailed explanation of Kalman Filtering and Space Space Models the following literature is a good starting point:
\itemize{
   \item{\cite{G. Welch, G. Bishop, An Introduction to the Kalman Filter. SIGGRAPH 2001 Course 8, 1995}}
   \item{\cite{Harvey, Andrew C. Forecasting, structural time series models and the Kalman filter. Cambridge university press, 1990} }
   \item{\cite{Grewal, Mohinder S. Kalman filtering. Springer Berlin Heidelberg, 2011}}
   }
}
\examples{
#Example 1: Perform imputation with KalmanSmoother and state space representation of arima model
na.kalman(tsAirgap)

#Example 2: Perform imputation with KalmanRun and state space representation of arima model
na.kalman(tsAirgap, smooth = FALSE)

#Example 3: Perform imputation with KalmanSmooth and StructTS model
na.kalman(tsAirgap, model ="StructTS", smooth = TRUE) 

#Example 4: Perform imputation with KalmanSmooth and StructTS model with additional parameters 
na.kalman(tsAirgap, model ="StructTS", smooth = TRUE, type ="trend") 

#Example 5:  Perform imputation with KalmanSmooth and user created model
usermodel <- arima(tsAirgap,order = c(1,0,1))$model
na.kalman(tsAirgap,model = usermodel)

}
\references{
Hyndman RJ and Khandakar Y (2008). "Automatic time series forecasting: the forecast package for R". Journal of Statistical Software, 26(3).
}
\seealso{
\code{\link[imputeTS]{na.interpolation}},
 \code{\link[imputeTS]{na.locf}},
 \code{\link[imputeTS]{na.ma}}, \code{\link[imputeTS]{na.mean}},
 \code{\link[imputeTS]{na.random}}, \code{\link[imputeTS]{na.replace}},
 \code{\link[imputeTS]{na.seadec}}, \code{\link[imputeTS]{na.seasplit}}
}
\author{
Steffen Moritz
}
