% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inca.R
\docType{package}
\name{inca-package}
\alias{inca}
\alias{inca-package}
\title{Integer Calibration}
\description{
Specific functions are provided for rounding real weights to integers and performing an integer programming algorithm for calibration problems
}
\details{
\tabular{ll}{
Package: \tab inca\cr
Type: \tab Package\cr
Version: \tab 2016-09-14\cr
Date: \tab 0.0.2\cr
License: \tab GPL (>= 2)\cr
}

Calibration forces the weighted estimates of calibration variables to match known totals. 
This improves the quality of the design-weighted estimates. It is used to adjust for 
non-response and/or under-coverage. The commonly used methods of calibration produce 
non-integer weights. In cases where weighted estimates must be integers, one must 
"integerize" the calibrated weights. However, this procedure often produces final weights 
that are very different for the "sample" weights. To counter this problem, the *inca* 
package provides specific functions for rounding real weights to integers, and performing 
an integer programming algorithm for calibration problems with integer weights.

For a complete list of exported functions, use \code{library(help = "inca")}.
}
\examples{
library(inca)

}
\author{
Luca Sartore \email{luca.sartore@nass.usda.gov} and Kelly Toppin \email{kelly.toppin@nass.usda.gov}

Maintainer: Luca Sartore \email{drwolf85@gmail.com}
}
\references{
Theberge, A. (1999). Extensions of calibration estimators in survey sampling. Journal of the American Statistical Association, 94(446), 635-644.


Little, R. J., & Vartivarian, S. (2003). On weighting the rates in non-response weights.
Kish, L. (1992). Weighting for unequal Pi. Journal of Official Statistics, 8(2), 183.

Rao, J. N. K., & Singh, A. C. (1997). A ridge-shrinkage method for range-restricted weight calibration in survey sampling. In Proceedings of the section on survey research methods (pp. 57-65). American Statistical Association Washington, DC.

Horvitz, D. G., & Thompson, D. J. (1952). A generalization of sampling without replacement from a finite universe. Journal of the American Statistical Association, 47(260), 663-685.

Horvitz, D. G., & Thompson, D. J. (1952). A generalization of sampling without replacement from a finite universe. Journal of the American Statistical Association, 47(260), 663-685.

Kalton, G., & Flores-Cervantes, I. (2003). Weighting methods. Journal of Official Statistics, 19(2), 81-98.
}
\keyword{calibration}
\keyword{integer}
\keyword{rounding}

