% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_incadata.R
\name{use_incadata}
\alias{use_incadata}
\title{Use incadata from file or dataframe df}
\usage{
use_incadata(file, cache = TRUE, sep = ";", dec = ",", ...)
}
\arguments{
\item{file}{file name as character (ignored if called from INCA)}

\item{cache}{use cache to speed up the loading (see section: "cache_date"). 
\code{TRUE} by default}

\item{sep, dec}{arguments passed to \code{\link{read.csv2}}}

\item{...}{arguments passed to \code{\link{as.incadata}}.}
}
\value{
An \code{incadata} object containing a representation of the data in
the file (or \code{df}).
}
\description{
Read in a file (locally) or use global object named \code{df} (on INCA) 
and coerce to \code{incadata}-object.
}
\section{Cache}{
 To process all data through \code{\link{as.incadata}} can be
  time consuming for large data sets. It is therefore advised to use caching 
  (argument \code{cache = TRUE}) to avoid unnecessary processing of already
  formatted data. If \code{cache = TRUE}, the function will read and process
  the data only the first time (or if the original data is later changed). A
  processed and cached version of the data is saved with suffix ".rds". The
  cached version is always compared to the original file by its MD5 sum and 
  is updated if needed.
}

\examples{
\dontrun{
# Create a csv file with example data in a temporary directory
fl <- tempfile("ex_data", fileext = ".csv2")
write.csv2(incadata::ex_data, fl)

# First time the file is read from csv2
use_incadata(fl)
dir(tempdir) # a cache file is saved along the original csv2-file
use_incadata(fl) # Next time file loaded from cache
}
}
