% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_missing.R
\name{specify_missing}
\alias{specify_missing}
\title{Specify missing values for a vector}
\usage{
specify_missing(x, ..., default_missing = c("", NA, "blanks"))
}
\arguments{
\item{x}{vector}

\item{...}{values that should be changed to \code{NA} if found in \code{x}}

\item{default_missing}{a vector with additional default values to change 
to NA. 
These are treated the same as \code{...} but are added by default if not 
removed. 
  A special value \code{"blank"} can be used to indicate all empty strings 
  (all
  characters matching \code{[:blank:]}, see \link{regex}).}
}
\value{
x itself but with specified values set to \code{NA}.
}
\description{
Change specified values to NA
}
\examples{
x <- sample(100)
x[sample(100, 10)] <- 999
specify_missing(x, 999)
}
