% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/independence.R
\name{relative.order}
\alias{relative.order}
\title{The relative order of two vectors}
\usage{
relative.order(xs, ys, na.rm = TRUE, collisions = TRUE)
}
\arguments{
\item{xs, ys}{Numeric vectors of same length.}

\item{na.rm}{Logical: Should missing values, \code{NaN}, and \code{Inf} be removed?}

\item{collisions}{Logical: Warn of repeating values in \code{xs} or \code{ys}.}
}
\value{
An integer vector which describes the ordering of the second argument
\code{ys}, in terms of the ordering of the corresponding values in the
first argument \code{xs}.

For example, if \code{xs[3]} is the \code{i}th smallest
and \code{ys[3]} is the \code{j}th smallest,
then the returned value in position \code{i} is \code{j}.
}
\description{
Given (X1,Y1),...,(Xn,Yn), many nonparametric statistics depend only
on the permutation P that satisfies rank Yi = P[rank Xi].
The function \code{relative_order} computes such P given X1,...,Xn and Y1,...,Yn.
}
\details{
By default, the function removes missing values, and warns of
repeating values.
Then it computes the relative order by calling the base R function
\code{\link{order}} twice: \code{order(xs[order(ys)])}.

Ties may be broken arbitrarily, depending on the behavior of the function
\code{order}.
}
\examples{
relative.order(1:5, c(10,30,50,40,20))
## [1] 1 3 5 4 2

relative.order(c(1,2,5,3,4), c(10,30,50,40,20))
## [1] 1 3 4 2 5

set.seed(123)
relative.order(runif(8), runif(8))
## [1] 5 4 8 1 3 2 7 6
}
