pruneindicators<-function(speciescomb, At=0, Bt=0, sqrtIVt=0, max.indicators=4, verbose=FALSE) {

nonnested <- function (speciescomb, selection=NULL, verbose=FALSE) {
	if(is.null(selection)) selection = rep(TRUE, nrow(speciescomb$C))
	c = speciescomb$C[selection,]
	xc = speciescomb$XC[, selection]
	combs = row.names(c)
  	keep = rep(TRUE, ncol(xc))
  	for(c1 in 1:ncol(xc)) {
  		ccx1 = xc[,c1]>0
  	  	for(c2 in 1:ncol(xc)) { 	  	
	  		ccx2 = xc[,c2]>0
  			if(c1!=c2 && keep[c2]) {
  				if(sum(ccx1 & ccx2)==sum(ccx2) && sum(ccx1)>sum(ccx2)) {
  					keep[c2] = FALSE
  					if(verbose) cat(paste(combs[c2],"nested in",combs[c1],"\n"))
  				}
  				else if(sum(ccx1 & ccx2)==sum(ccx2) && sum(ccx1 & ccx2)==sum(ccx1)) {
  					if(verbose) cat(paste(combs[c2],"equal to",combs[c1],"\n"))
  					if(sum(c[c2,])> sum(c[c1,])) keep[c2] = FALSE
  					else if(sum(c[c1,])> sum(c[c2,])) keep[c1] = FALSE
  				}
  			}
      	}
 	}	
  	return(combs[keep])
}

	initCoverage<-coverage(speciescomb)
	if(verbose) cat(paste("Coverage of initial set of ",nrow(speciescomb$C)," indicators: ", round(initCoverage*100, digits=1),"%\n", sep=""))
	
	if(length(dim(speciescomb$A))==2) {
		selection<- speciescomb$A$lowerCI>=At & speciescomb$B$lowerCI>=Bt & speciescomb$sqrtIV$lowerCI>=sqrtIVt
	} else {
		selection<- speciescomb$A>=At & speciescomb$B>=Bt & speciescomb$sqrtIV>=sqrtIVt
	}
    if(sum(selection)==0) {
    	if(verbose) cat(paste("No indicator is valid using the given thresholds."))
    	return()
    }
	validCoverage<-coverage(speciescomb, selection)
	if(verbose) cat(paste("Coverage of valid set of ",sum(selection)," indicators: ", round(validCoverage*100, digits=1),"%\n", sep=""))
	
	if(sum(selection)>1) {
	    NN <-nonnested(speciescomb, selection=selection, verbose=FALSE)
		selection <- row.names(speciescomb$C) %in% NN
		nnCoverage<-coverage(speciescomb, selection)
		if(verbose) cat(paste("Coverage of valid set of ",sum(selection)," nonnested indicators: ", round(nnCoverage*100, digits=1),"%\n", sep=""))
	
	
		c = speciescomb$C[selection,]
		group.vec = speciescomb$group.vec
		xc = speciescomb$XC[, selection]

		#Preliminaries	
  		spnames = names(c)
  		spplist = names(c)

		indnames<-row.names(c)
		k <- length(indnames)
		j=1
		continue = TRUE
    	selmodFinal = selection
   		while(continue) {
      		co <- combn(k,j) #Generate subsets of indicators
   			if(verbose) cat(paste("Checking ",ncol(co)," subsets of ", j," indicator(s)", sep=""))
	      	keep2 = rep(FALSE,ncol(co))
   	   		maxcov = 0
	      	for(coi in 1:ncol(co)) { #Check coverage of subsets of indicators
	      		if(ncol(co)>10) if(coi%%round(ncol(co)/10)==0 && verbose) cat(".")
	      		selmod = selection
	      		selmod[selection]=FALSE
	      		selmod[selection][co[,coi]]=TRUE
	      		coicov = coverage(speciescomb, selmod)
	      		if(coicov>maxcov) {
	      		   bestAtPoint= coi
	      		   maxcov = coicov
	      		}
		  		keep2[coi]=coicov== nnCoverage
	      	}
	        if(verbose) cat(paste(" maximum coverage: ", round(maxcov*100, digits=1),"%\n",sep=""))
	      	if(sum(keep2)>0) { #If at least one subset has the appropriate coverage keep it
	      		best = which(keep2)[1]
	      		selmodFinal[selection]=FALSE
	      		selmodFinal[selection][co[,best]]=TRUE
	      		finalCoverage<-coverage(speciescomb, selmodFinal)
				if(verbose) cat(paste("Coverage of final set of ", j, " indicators: ",round(finalCoverage*100,digits=1),"%\n", sep=""))
	      		continue = FALSE
	      	} else {
		      	if(j==max.indicators) {
	    	  		selmodFinal[selection]=FALSE
		      		selmodFinal[selection][co[,bestAtPoint]]=TRUE
					if(verbose) cat(paste("\nCoverage maximum allowed set of ", j, " indicators: ",round(maxcov*100,digits=1),"%\n", sep=""))
		      	}
	      	}
	      	if(j<min(max.indicators,k)) j= j+1
  	    	else continue = FALSE
	    }
	} else {
		if(verbose) cat(paste("One valid indicator only. Stopping.\n", sep=""))
		selmodFinal = selection
	}
    speciescomb2 = speciescomb
    speciescomb2$C = as.data.frame(subset(speciescomb2$C, subset=selmodFinal))
    speciescomb2$XC = speciescomb2$XC[,selmodFinal]
    if(length(dim(speciescomb2$A))==2) {
    	speciescomb2$A = speciescomb2$A[selmodFinal,]
	    speciescomb2$B = speciescomb2$B[selmodFinal,]
    	speciescomb2$sqrtIV = speciescomb2$sqrtIV[selmodFinal,]
    } else {
    	speciescomb2$A = speciescomb2$A[selmodFinal]
	    speciescomb2$B = speciescomb2$B[selmodFinal]
    	speciescomb2$sqrtIV = speciescomb2$sqrtIV[selmodFinal]
    }

  	selSpp = colSums(speciescomb2$C)>0
  	speciescomb2$C = as.data.frame(speciescomb2$C[,selSpp])
  	row.names(speciescomb2$C)<-row.names(speciescomb$C)[selmodFinal]
  	names(speciescomb2$C)<-names(speciescomb$C)[selSpp]
  	
    #Select rows that contain the species or the group
    if(sum(selmodFinal)>1) {
	  	selRows = rowSums(speciescomb2$XC)>0 | speciescomb2$group.vec
	  	speciescomb2$group.vec = speciescomb2$group.vec[selRows]
	  	speciescomb2$XC = speciescomb2$XC[selRows,]
	} else {
	  	selRows = sum(speciescomb2$XC) | speciescomb2$group.vec
	  	speciescomb2$group.vec = speciescomb2$group.vec[selRows]
	  	speciescomb2$XC = speciescomb2$XC[selRows]
	}
    
	return(speciescomb2)
}



