% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strassoc.R
\name{strassoc}
\alias{strassoc}
\title{Strength of species site-group associations}
\usage{
strassoc(
  X,
  cluster,
  func = "r",
  group = NULL,
  nboot.ci = NULL,
  alpha.ci = 0.05,
  c = 1
)
}
\arguments{
\item{X}{Community data table (rows are sites, columns are species).}

\item{cluster}{A vector of numeric group labels for sites.}

\item{func}{The association index to be used. Accepted function names: "r", "r.g", "IndVal", "IndVal.g", "A", "A.g", "B", "cos", "cos.g", "r.ind", "r.ind.g", "s.ind", "s.ind.g" (lowercase values are also accepted).}

\item{group}{Group for which association values are to be computed. If group=NULL, association values will be computed for all groups.}

\item{nboot.ci}{Number of bootstrap samples. If \code{NULL} then confidence intervals are not estimated.}

\item{alpha.ci}{Error in confidence intervals.}

\item{c}{Vector of total abundance per site (used in functions "r.ind", "r.ind.g", "s.ind", "s.ind.g" only).}
}
\value{
Returns a matrix of association values, where species are in rows and groups are in columns. If \code{nboot.ci} is not null, then a list is returned, where 'stat' contains the matrix of association values, and the lower and upper confidence limits are given in supplementary matrices named 'lowerCI' and 'upperCI' respectively.
}
\description{
This function computes the strength of the association between a species vector and a vector of memberships to the site-group. Several statistics are possible, following De \enc{Cáceres}{Caceres} and Legendre (2009). The choice of the most appropriate statistic depends on the application. If required, bootstrap confidence interval bounds are also computed.
}
\details{
This R function is applicable to both presence-absence and quantitative species data, depending on the values in the input matrix X.  Indices "r","r.g","cos" and "cos.g" correspond to the general correlation generalization ("r" is the point-biserial correlation coefficient), whereas "r.ind", "r.ind.g", "s.ind" and "s.ind.g" correspond to the individual-based generalization. Both approaches give the same results for binary (presence-absence) species data. Indicator value indices "IndVal" and "IndVal.g" are partial generalizations of the indices of the presence-absence indices. The "IndVal" index of \enc{Dufrêne}{Dufrene} & Legendre (1997) is called "IndVal.g" here and \code{strassoc} returns the square root of the original index. Indices "A","A.g" and "B" are the asymmetric quantities into which indicator values "IndVal" and "IndVal.g" can be decomposed. See De Cáceres and Legendre for details on the relationships between these indices and their usage. Bootstrap confidence intervals are computed using the simple percentile method (Manly 1997).
}
\note{
This function gives the same association values as function \code{indval} in package "labdsv" when used setting \code{func="IndVal.g"}, excepting the fact that the square root IndVal values is returned instead of the original IndVal.
}
\examples{
## Load species data
data(wetland) 

## Create three clusters using
wetkm <- kmeans(wetland, centers=3)

## Compute Dufrene and Legendre's IndVal
strassoc(wetland, wetkm$cluster, func="IndVal.g") 

## Compute correlation, with bootstrap 95 percent confidence intervals
strassoc(wetland, wetkm$cluster, func="r.g", 
         nboot.ci =100) 
         
}
\references{
De \enc{Cáceres}{Caceres}, M. and Legendre, P. 2009. Associations between species and groups of sites: indices and statistical inference. Ecology 90(12): 3566-3574.

\enc{Dufrêne}{Dufrene}, M. and P. Legendre. 1997. Species assemblages and indicator species: The need for a flexible asymetrical approach. Ecological Monographs 67:345-366.

Manly, B. F. J. 1997. Randomization, bootstrap and Monte Carlo methods in biology. Chapman and Hall Texts in Statistical Science Series.
}
\seealso{
\code{\link{signassoc}}, \code{\link{multipatt}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa,  EMF-CREAF
}
