% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifr-runs-test.R
\name{infer_runs_test}
\alias{infer_runs_test}
\title{Test for Random Order}
\usage{
infer_runs_test(
  data,
  x,
  drop = FALSE,
  split = FALSE,
  mean = FALSE,
  threshold = NA
)
}
\arguments{
\item{data}{a \code{data.frame} or \code{tibble}}

\item{x}{numeric; column in \code{data}}

\item{drop}{logical; if TRUE, values equal to the threshold will be dropped
from \code{x}}

\item{split}{logical; if TRUE, data will be recoded in binary format}

\item{mean}{logical; if TRUE, mean will be used as threshold}

\item{threshold}{threshold to be used for counting runs, specify 0 if data
is coded as a binary.}
}
\value{
\code{infer_runs_test} returns an object of class \code{"infer_runs_test"}.
An object of class \code{"infer_runs_test"} is a list containing the
following components:

\item{n}{number of observations}
\item{threshold}{within group sum of squares}
\item{n_below}{number below the threshold}
\item{n_above}{number above the threshold}
\item{mean}{expected number of runs}
\item{var}{variance of the number of runs}
\item{n_runs}{number of runs}
\item{z}{z statistic}
\item{p}{p-value of \code{z}}
}
\description{
runtest tests whether the observations of \code{x} are serially
independent i.e. whether they occur in a random order, by counting
how many runs there are above and below a threshold.  By default, the median
is used as the threshold.  A small number of runs indicates positive serial
correlation; a large number indicates negative serial correlation.
}
\section{Deprecated Function}{

\code{runs_test()} has been deprecated. Instead use \code{infer_runs_test()}.
}

\examples{
infer_runs_test(hsb, read)

infer_runs_test(hsb, read, drop = TRUE)

infer_runs_test(hsb, read, split = TRUE)

infer_runs_test(hsb, read, mean = TRUE)

infer_runs_test(hsb, read, threshold = 0)

}
\references{
{Sheskin, D. J. 2007. Handbook of Parametric and Nonparametric Statistical Procedures, 4th edition. : Chapman & Hall/CRC.}

{Edgington, E. S. 1961. Probability table for number of runs of signs of first differences in ordered series. Journal of the American Statistical Association 56: 156–159.}

{Madansky, A. 1988. Prescriptions for Working Statisticians. New York: Springer.}

{Swed, F. S., and C. Eisenhart. 1943. Tables for testing randomness of grouping in a sequence of alternatives. Annals of Mathematical Statistics 14: 66–87.}
}
