% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{graph_from_incidence_matrix}
\alias{graph_from_incidence_matrix}
\alias{incidencematrix2graph}
\title{Creating igraph graphs from incidence matrices}
\usage{
graph_from_incidence_matrix(
  incidence,
  directed = FALSE,
  mode = c("all", "out", "in", "total"),
  multiple = FALSE,
  weighted = NULL,
  add.names = NULL
)
}
\arguments{
\item{incidence}{The input incidence matrix. It can also be a sparse matrix from the \code{Matrix} package.}

\item{directed}{Logical scalar, whether to create a directed graph.}

\item{mode}{A character constant, defines the direction of the edges in directed graphs,
ignored for undirected graphs. If ‘out’, then edges go from vertices of the first
kind (corresponding to rows in the incidence matrix) to vertices of the second
kind (columns in the incidence matrix). If ‘in’, then the opposite direction is used.
If ‘all’ or ‘total’, then mutual edges are created.}

\item{multiple}{Logical scalar, specifies how to interpret the matrix elements. See details below.}

\item{weighted}{This argument specifies whether to create a weighted graph from
the incidence matrix. If it is NULL then an unweighted graph is created and the
multiple argument is used to determine the edges of the graph. If it is a character
constant then for every non-zero matrix entry an edge is created and the value of
the entry is added as an edge attribute named by the weighted argument. If it is
TRUE then a weighted graph is created and the name of the edge attribute will be ‘weight’.}

\item{add.names}{A character constant, NA or NULL. \code{graph_from_incidence_matrix}
can add the row and column names of the incidence matrix as vertex attributes.
If this argument is NULL (the default) and the incidence matrix has both row
and column names, then these are added as the ‘name’ vertex attribute. If you want a different vertex attribute for this, then give the name of the attributes as a character string. If this argument is NA, then no vertex attributes (other than type) will be added.}
}
\value{
A bipartite igraph graph. In other words, an igraph graph that has a vertex attribute type.
}
\description{
This function and all of its descriptions have been obtained from the igraph package.
}
\details{
Bipartite graphs have a ‘type’ vertex attribute in igraph, this is boolean
and FALSE for the vertices of the first kind and TRUE for vertices of the second kind.

graph_from_incidence_matrix can operate in two modes, depending on the multiple
argument. If it is FALSE then a single edge is created for every non-zero element
in the incidence matrix. If multiple is TRUE, then the matrix elements are
rounded up to the closest non-negative integer to get the number of edges to
create between a pair of vertices.
}
\examples{
\dontrun{
inc <- matrix(sample(0:1, 15, repl=TRUE), 3, 5)
colnames(inc) <- letters[1:5]
rownames(inc) <- LETTERS[1:3]
My_graph <- graph_from_incidence_matrix(inc)
}
}
\seealso{
\code{\link[igraph]{graph_from_incidence_matrix}} for a complete description on this function

Other network_reconstruction functions: 
\code{\link{graph_from_adjacency_matrix}()},
\code{\link{graph_from_data_frame}()},
\code{\link{sif2igraph}()}
}
\concept{network_reconstruction functions}
\keyword{graph_from_incidencematrices}
