% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influxdb_main.R
\name{influx_connection}
\alias{influx_connection}
\title{Create an influxdb_connection object}
\usage{
influx_connection(scheme = c("http", "https"), host = "localhost",
  port = 8086, user = "user", pass = "pass", path = "/", group = NULL,
  verbose = FALSE, config_file = "~/.influxdb.cnf")
}
\arguments{
\item{scheme}{The scheme to use, either http or https. Defaults to http.}

\item{host}{Hostname of the InfluxDB server. Defaults to localhost}

\item{port}{numerical. Port number of the InfluxDB server. Defaults to 8086.}

\item{user}{username The username to use. Defaults to "user"}

\item{pass}{password The password to use. Defaults to "pass".}

\item{path}{The prefix path on which the InfluxDB is running. Can be useful
in proxy situations.}

\item{group}{The group to use within the config file.}

\item{verbose}{logical. Provide additional details?}

\item{config_file}{The configuration file to be used if \code{group} is
specified.}
}
\description{
Create an influxdb_connection object by specifying server
connection details. Credentials can also be saved and accessed through a
config file.
}
\section{structure of configuration file}{

A configuration file may contain several connection settings. Each setting
has the following structure:\cr\preformatted{[group]
scheme=http
host=localhost  
port=8086
user=username
pass=password  
path=/
}
}

\references{
\url{https://influxdb.com/}
}
