% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeContrMat.R
\name{makeContrMat}
\alias{makeContrMat}
\title{Make Contrast Matrix}
\usage{
makeContrMat(design.df, effectNames, effectsMatrix, contr.vec)
}
\arguments{
\item{design.df}{a data frame containing the experimental design. Requires
every column be a \code{\link{factor}}.}

\item{effectNames}{a vector of character containing the labels of the
treatment or block terms in the model generated by the \code{\link{terms}}.}

\item{effectsMatrix}{a matrix of variables by terms showing which variables
appear in which terms generated by the \code{\link{terms}}.}

\item{contr.vec}{a list of contrast vectors, this allows the user to
specify the contrasts for each treatment or block factor. Note that if this
argument is used, it is necessary to specify the contrasts for every
treatment or block factor with the same order as \code{effectNames}.
Default is \code{NA}, and the function output the C matrices described by
John and Williams (1987).}
}
\value{
A list of contrast matrices.
}
\description{
Construct a list of contrast matrices for block for treatment effects.
}
\details{
The main purpose of this function is to compute a list of C matrices
described by John and Williams (1987). These C matrices are used for the
information decomposition for every treatment effect in every stratum of
the experiment.

If the user input their own defined contrasts for each treatment effects.
This function will then transform the input contrasts to the C matrices for
the treatment effects.

For the two-phase experiments, the same method of information decomposition
is used for the block effects of Phase 1 experiment in the stratum defined
from the block structure of the Phase 2 experiment. Hence, the C matrices
for the block effects of Phase 1 experiment can also be constructed using
this function.
}
\examples{

design1 <- local({ 
  Ani = as.factor(LETTERS[c(1,2,3,4,
                            5,6,7,8)])
  Trt = as.factor(letters[c(1,1,1,1,
                            2,2,2,2)])
  data.frame(Ani, Trt)
})

trt.str = "Trt"              
fT <- terms(as.formula(paste("~", trt.str, sep = "")), keep.order = TRUE)  #fixed terms

trtTerm <- attr(fT, "term.labels")
effectsMatrix <- attr(fT, "factor")        

T <- makeContrMat(design1, trtTerm, effectsMatrix, contr.vec = NA)
		
#Fit each treatment contrasts as a vector seperately
Trt1 <- rep(c(1,-1), each = 4)
Trt2 <-  rep(c(1,-1), time = 4)
Trt3 <- Trt1*Trt2
  
T <- makeContrMat(design1, trtTerm, effectsMatrix, 
      contr.vec =list(Trt = list(Trt1 = Trt1, Trt2 = Trt2, Trt3 = Trt3)))


}
\references{
John J, Williams E (1987). \emph{Cyclic and computer generated
Designs}. Second edition. Chapman & Hall.
}
\author{
Kevin Chang
}
