% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/muni.R
\name{municipios}
\alias{municipios}
\title{Download data at the municipality level}
\usage{
municipios(tipo_eleccion, anno, mes, distritos = FALSE)
}
\arguments{
\item{tipo_eleccion}{The type of choice you want to download. The accepted values are "congreso", "senado", "europeas" o "municipales".}

\item{anno}{The year of the election in YYYY format.}

\item{mes}{The month of the election in MM format.}

\item{distritos}{Should district level results be returned when available? The default is FALSE. Please be aware when summarizing the data that districts = TRUE will return separate rows for the total municipal level and for each of the districts.}
}
\value{
Dataframe with the electoral results data at the municipality level.
}
\description{
`municipios()` downloads, formats and imports to the environment the electoral results data of the selected election at the municipality level.
}
\examples{
ua <- "Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko)"
options(HTTPUserAgent = ua)

data <- municipios(tipo_eleccion = "congreso", anno = "2019", mes = "11")
str(data)

}
