% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_aggregated_ceteris_paribus_explainer.R
\name{plot.aggregated_profiles_explainer}
\alias{plot.aggregated_profiles_explainer}
\title{Adds a Layer with Aggregated Profiles}
\usage{
\method{plot}{aggregated_profiles_explainer}(x, ..., size = 1,
  alpha = 1, color = "#371ea3", facet_ncol = NULL,
  variables = NULL)
}
\arguments{
\item{x}{a ceteris paribus explainer produced with function `ceteris_paribus()`}

\item{...}{other explainers that shall be plotted together}

\item{size}{a numeric. Size of lines to be plotted}

\item{alpha}{a numeric between 0 and 1. Opacity of lines}

\item{color}{a character. Either name of a color or name of a variable that should be used for coloring}

\item{facet_ncol}{number of columns for the `facet_wrap()`}

\item{variables}{if not NULL then only `variables` will be presented}
}
\value{
a ggplot2 layer
}
\description{
Function 'show_aggreagated_profiles' adds a layer to a plot created with 'plot.ceteris_paribus_explainer'.
}
\examples{
library("DALEX")
# Toy examples, because CRAN angels ask for them
titanic <- na.omit(titanic)
model_titanic_glm <- glm(survived == "yes" ~ gender + age + fare,
                       data = titanic, family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                           data = titanic[,-9],
                           y = titanic$survived == "yes")

pdp_rf_p <- partial_dependency(explain_titanic_glm, N = 50)
pdp_rf_p$`_label_` <- "RF_partial"
pdp_rf_l <- conditional_dependency(explain_titanic_glm, N = 50)
pdp_rf_l$`_label_` <- "RF_local"
pdp_rf_a<- accumulated_dependency(explain_titanic_glm, N = 50)
pdp_rf_a$`_label_` <- "RF_accumulated"
head(pdp_rf_p)
plot(pdp_rf_p, pdp_rf_l, pdp_rf_a, color = "_label_")

 \donttest{
 library("randomForest")
 titanic <- na.omit(titanic)
 model_titanic_rf <- randomForest(survived == "yes" ~ gender + age + class + embarked +
                                    fare + sibsp + parch,  data = titanic)
 model_titanic_rf

 explain_titanic_rf <- explain(model_titanic_rf,
                           data = titanic[,-9],
                           y = titanic$survived == "yes",
                           label = "Random Forest v7")

selected_passangers <- select_sample(titanic, n = 100)
cp_rf <- ceteris_paribus(explain_titanic_rf, selected_passangers)
cp_rf

pdp_rf_p <- aggregate_profiles(cp_rf, variables = "age", type = "partial")
pdp_rf_p$`_label_` <- "RF_partial"
pdp_rf_c <- aggregate_profiles(cp_rf, variables = "age", type = "conditional")
pdp_rf_c$`_label_` <- "RF_conditional"
pdp_rf_a <- aggregate_profiles(cp_rf, variables = "age", type = "accumulated")
pdp_rf_a$`_label_` <- "RF_accumulated"
head(pdp_rf_p)
plot(pdp_rf_p, pdp_rf_c, pdp_rf_a, color = "_label_")

plot(cp_rf, variables = "age") +
show_observations(cp_rf, variables = "age") +
  show_rugs(cp_rf, variables = "age", color = "red") +
  show_aggreagated_profiles(pdp_rf, size = 2)

plot(pdp_rf, variables = "age")

}
}
\references{
Predictive Models: Visual Exploration, Explanation and Debugging \url{https://pbiecek.github.io/PM_VEE}
}
