% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ceteris_paribus_explainer.R
\name{plot.ceteris_paribus_explainer}
\alias{plot.ceteris_paribus_explainer}
\title{Plots Ceteris Paribus Profiles}
\usage{
\method{plot}{ceteris_paribus_explainer}(x, ..., size = 1, alpha = 1,
  color = "#46bac2", only_numerical = TRUE, facet_ncol = NULL,
  variables = NULL)
}
\arguments{
\item{x}{a ceteris paribus explainer produced with function `ceteris_paribus()`}

\item{...}{other explainers that shall be plotted together}

\item{size}{a numeric. Size of lines to be plotted}

\item{alpha}{a numeric between 0 and 1. Opacity of lines}

\item{color}{a character. Either name of a color or name of a variable that should be used for coloring}

\item{only_numerical}{a logical. If TRUE then only numerical variables will be plotted. If FALSE then only categorical variables will be plotted.}

\item{facet_ncol}{number of columns for the `facet_wrap()`}

\item{variables}{if not NULL then only `variables` will be presented}
}
\value{
a ggplot2 object
}
\description{
Function 'plot.ceteris_paribus_explainer' plots Individual Variable Profiles for selected observations.
Various parameters help to decide what should be plotted, profiles, aggregated profiles, points or rugs.
}
\details{
Find more detailes in \href{https://pbiecek.github.io/PM_VEE/ceterisParibus.html}{Ceteris Paribus Chapter}.
}
\examples{
library("DALEX")
# Toy examples, because CRAN angels ask for them
titanic <- na.omit(titanic)
model_titanic_glm <- glm(survived == "yes" ~ gender + age + fare,
                       data = titanic, family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                           data = titanic[,-9],
                           y = titanic$survived == "yes")
cp_rf <- ceteris_paribus(explain_titanic_glm, titanic[1,])
cp_rf
plot(cp_rf, variables = "age")

 \donttest{
 library("randomForest")
 model_titanic_rf <- randomForest(survived == "yes" ~ gender + age + class + embarked +
                                    fare + sibsp + parch,  data = titanic)
 model_titanic_rf

 explain_titanic_rf <- explain(model_titanic_rf,
                           data = titanic[,-9],
                           y = titanic$survived == "yes",
                           label = "Random Forest v7")

selected_passangers <- select_sample(titanic, n = 100)
cp_rf <- ceteris_paribus(explain_titanic_rf, selected_passangers)
cp_rf

plot(cp_rf, variables = "age") +
show_observations(cp_rf, variables = "age") +
  show_rugs(cp_rf, variables = "age", color = "red")

}
}
\references{
Predictive Models: Visual Exploration, Explanation and Debugging \url{https://pbiecek.github.io/PM_VEE}
}
