% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotD3_feature_importance.R
\name{plotD3.feature_importance_explainer}
\alias{plotD3.feature_importance_explainer}
\title{Plot Feature Importance Objects in D3 with r2d3 Package.}
\usage{
\method{plotD3}{feature_importance_explainer}(
  x,
  ...,
  max_vars = NULL,
  show_boxplots = TRUE,
  bar_width = 12,
  split = "model",
  scale_height = FALSE,
  margin = 0.15,
  chart_title = "Feature importance"
)
}
\arguments{
\item{x}{a feature importance explainer produced with the \code{feature_importance()} function}

\item{...}{other explainers that shall be plotted together}

\item{max_vars}{maximum number of variables that shall be presented for for each model.
By default \code{NULL} which means all variables}

\item{show_boxplots}{logical if \code{TRUE} (default) boxplot will be plotted to show permutation data.}

\item{bar_width}{width of bars in px. By default \code{12px}}

\item{split}{either "model" or "feature" determines the plot layout}

\item{scale_height}{a logical. If \code{TRUE}, the height of plot scales with window size. By default it's \code{FALSE}}

\item{margin}{extend x axis domain range to adjust the plot.
Usually value between \code{0.1} and \code{0.3}, by default it's \code{0.15}}

\item{chart_title}{a character. Set custom title}
}
\value{
a \code{r2d3} object.
}
\description{
Function \code{\link{plotD3.feature_importance_explainer}} plots dropouts for variables used in the model.
It uses output from \code{\link{feature_importance}} function that corresponds to permutation based measure of feature importance.
Variables are sorted in the same order in all panels. The order depends on the average drop out loss.
In different panels variable contributions may not look like sorted if variable importance is different in different models.
}
\examples{
library("DALEX")
library("ingredients")

lm_model <- lm(m2.price ~., data = apartments)
explainer_lm <- explain(lm_model,
                        data = apartments[,-1],
                        y = apartments[,1],
                        verbose = FALSE)

fi_lm <- feature_importance(explainer_lm,
      loss_function = DALEX::loss_root_mean_square, B = 1)

head(fi_lm)
plotD3(fi_lm)

\donttest{
library("ranger")

rf_model <- ranger(m2.price~., data = apartments)

explainer_rf <- explain(rf_model,
                        data = apartments[,-1],
                        y = apartments[,1],
                        label = "ranger forest",
                        verbose = FALSE)

fi_rf <- feature_importance(explainer_rf, loss_function = DALEX::loss_root_mean_square)

head(fi_rf)
plotD3(fi_lm, fi_rf)

plotD3(fi_lm, fi_rf, split = "feature")

plotD3(fi_lm, fi_rf, max_vars = 3, bar_width = 16, scale_height = TRUE)
plotD3(fi_lm, fi_rf, max_vars = 3, bar_width = 16, split = "feature", scale_height = TRUE)
plotD3(fi_lm, margin = 0.2)
}

}
\references{
Explanatory Model Analysis. Explore, Explain, and Examine Predictive Models. \url{http://ema.drwhy.ai/}
}
