% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{gg.SpatialPolygons}
\alias{gg.SpatialPolygons}
\title{Geom for SpatialPolygons objects}
\usage{
\method{gg}{SpatialPolygons}(data, mapping = NULL, crs = NULL,
  color = "black", alpha = NULL, ...)
}
\arguments{
\item{data}{A SpatialPolygons object.}

\item{mapping}{Aesthetic mappings created by \link{aes} or \link{aes_} used to update the default
mapping. The default mapping is \code{aes_string(x = "long", y = "lat", group = "group")}.}

\item{crs}{A \link{CRS} object defining the coordinate system to project the data to before plotting.}

\item{color}{Filling color for the polygons.}

\item{alpha}{Alpha level for polygon filling.}

\item{...}{Arguments passed on to \link{geom_polygon}.}
}
\value{
A \link{geom_polygon} return value.
}
\description{
Uses the fortitfy() function to turn the SpatialPolygons objects into a data.frame. Then 
calls \link{geom_polygon} to plot the polygons.
}
\examples{
# Load Gorilla data

data("gorillas")

# Plot Gorilla elevation covariate provided as SpatialPixelsDataFrame. 
# The same syntax applies to SpatialGridDataFrame objects.

ggplot() + gg(gorillas$gcov$elevation)

# Add Gorilla survey boundary and nest sightings

ggplot() + 
  gg(gorillas$gcov$elevation) + 
  gg(gorillas$boundary) +
  gg(gorillas$nests)

# Load pantropical dolphin data

data("mexdolphin")

# Plot the pantropiical survey boundary, ship transects and dolphin sightings

ggplot() + 
  gg(mexdolphin$ppoly) + # survey boundary as SpatialPolygon
  gg(mexdolphin$samplers) + # ship transects as SpatialLines
  gg(mexdolphin$points)  # dolphin sightings as SpatialPoints

# Change color

ggplot() + 
  gg(mexdolphin$ppoly, color = "green") + # survey boundary as SpatialPolygon
  gg(mexdolphin$samplers, color = "red") + # ship transects as SpatialLines
  gg(mexdolphin$points, color = "blue")  # dolphin sightings as SpatialPoints


# Visualize data annotations: line width by segment number

names(mexdolphin$samplers) # 'seg' holds the segment number
ggplot() + gg(mexdolphin$samplers, aes(color = seg))

# Visualize data annotations: point size by dolphin group size

names(mexdolphin$points) # 'size' holds the group size
ggplot() + gg(mexdolphin$points, aes(size = size))
}
\seealso{
Other geomes for spatial data: \code{\link{gg.SpatialGridDataFrame}},
  \code{\link{gg.SpatialLines}},
  \code{\link{gg.SpatialPixelsDataFrame}},
  \code{\link{gg.SpatialPixels}},
  \code{\link{gg.SpatialPoints}}, \code{\link{gg}},
  \code{\link{gm}}
}
