% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R, R/inla.R
\name{plot.bru}
\alias{plot.bru}
\alias{plotmarginal.inla}
\title{Plot method for posterior marginals estimated by bru}
\usage{
\method{plot}{bru}(x, ...)

plotmarginal.inla(
  result,
  varname = NULL,
  index = NULL,
  link = function(x) {
     x
 },
  add = FALSE,
  ggp = TRUE,
  lwd = 3,
  ...
)
}
\arguments{
\item{x}{a fitted \code{\link[=bru]{bru()}} model.}

\item{...}{Options passed on to other methods.}

\item{result}{an \code{inla} or \code{bru} result object}

\item{varname}{character; name of the variable to plot}

\item{index}{integer; index of the random effect to plot}

\item{link}{function; link function to apply to the variable}

\item{add}{logical; if \code{TRUE}, add to an existing plot}

\item{ggp}{logical; unused}

\item{lwd}{numeric; line width}
}
\description{
From version \verb{2.11.0}, \code{plot.bru(x, ...)} calls \code{plot.inla(x, ...)}
from the \code{INLA} package, unless the first argument after \code{x} is a
\code{character}, in which case the pre-\verb{2.11.0} behaviour is used, calling
\code{plotmarginal.inla(x, ...)} instead.

Requires the \code{ggplot2} package.
}
\examples{
\dontrun{
if (require("ggplot2", quietly = TRUE)) {
  # Generate some data and fit a simple model
  input.df <- data.frame(x = cos(1:10))
  input.df <- within(
    input.df,
    y <- 5 + 2 * x + rnorm(length(x), mean = 0, sd = 0.1)
  )
  fit <- bru(y ~ x, family = "gaussian", data = input.df)
  summary(fit)

  # Plot the posterior density of the model's x-effect
  plot(fit, "x")
}
}

}
