% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_testthat.R
\name{local_testthat}
\alias{local_testthat}
\alias{local_testthat_assign}
\alias{local_testthat_tolerances}
\alias{local_bru_options_set}
\alias{local_set_PROJ6_warnings}
\alias{local_get_rgdal_options}
\alias{local_disable_PROJ6_warnings}
\alias{local_basic_intercept_testdata}
\alias{local_basic_fixed_effect_testdata}
\alias{local_mrsea_convert}
\alias{local_bru_safe_inla}
\alias{local_bru_testthat_setup}
\title{Unit test helpers}
\usage{
local_testthat_assign(x, values, envir = parent.frame())

local_testthat_tolerances(
  tolerances = c(1e-05, 0.01, 0.1),
  envir = parent.frame()
)

local_bru_options_set(..., .reset = FALSE, envir = parent.frame())

local_set_PROJ6_warnings(proj4 = FALSE, thin = TRUE, envir = parent.frame())

local_get_rgdal_options()

local_disable_PROJ6_warnings(envir = parent.frame())

local_basic_intercept_testdata()

local_basic_fixed_effect_testdata()

local_mrsea_convert(x, use_km = FALSE)

local_bru_safe_inla(multicore = FALSE, quietly = TRUE, envir = parent.frame())

local_bru_testthat_setup(envir = parent.frame())
}
\arguments{
\item{x}{character; Name of variable to assign to}

\item{values}{the object to assign to \code{x}}

\item{envir}{environment for exit handlers}

\item{tolerances}{numeric vector of length 3; \verb{[lowtol, midtol, hitol]}}

\item{.reset}{For \code{local_bru_options_set}, logical indicating if the global
override options list should be emptied before setting the new option(s).}

\item{proj4}{logical; whether to show PROJ4 conversion warnings. Default \code{FALSE}}

\item{thin}{logical; whether to show only a thinned version of rgdal PROJ6
warnings. Default \code{TRUE}}

\item{multicore}{logical; if \code{TRUE}, multiple cores are allowed, and the
INLA \code{num.threads} option is not checked or altered. Default: \code{FALSE}, multicore
not allowed (used for examples and unit tests).}

\item{quietly}{logical; if \code{TRUE}, prints diagnostic messages. A message is
always printed if the INLA \code{num.threads} option is altered, regardless of the
\code{quietly} argument. Default: TRUE.}
}
\value{
\code{local_bru_options_set()} returns a copy of the global override
options (not including the defaults), invisibly.
}
\description{
Local helper functions for package unit tests
}
\details{
\code{local_bru_options_set()} is used to set global package options.
}
\section{Functions}{
\itemize{
\item \code{local_testthat_assign}: Assign local variable. Useful for easy cleanup
of global workspace with \code{withr::deferred_run()} when running tests
interactively.

\item \code{local_testthat_tolerances}: Assign test tolerances
Assign local tolerance variables. Useful for easy cleanup
of global workspace with \code{withr::deferred_run()} when running tests
interactively.

\item \code{local_bru_options_set}: Calls \code{\link[=bru_options_set]{bru_options_set()}} in a reversible way

\item \code{local_set_PROJ6_warnings}: Disable PROJ4/6 warnings.
To be used within package tests. Restores state on exit.

\item \code{local_get_rgdal_options}: Return a list of the current rgdal warning options

\item \code{local_disable_PROJ6_warnings}: Disable rgdal PROJ4 conversion warnings and thin
PROJ6 warnings.

\item \code{local_bru_safe_inla}: Tests should set num.threads = "1:1" to ensure
within-system repeatability by calling \code{local_bru_safe_inla()};
see also \code{\link[=bru_safe_inla]{bru_safe_inla()}}

\item \code{local_bru_testthat_setup}: Initialise environment for tests.
Disables PROJ4/PROJ6 warnings, and assigns tolerance variables.
To be called either at the top of a testfile, or inside tests.
Does \emph{not} call \code{\link[=local_bru_safe_inla]{local_bru_safe_inla()}}, since that may invoke a skip and
should be called inside each test that relies on INLA.
}}

\examples{
my_fun <- function(val) {
  local_bru_options_set(bru_verbose = val)
  bru_options_get("bru_verbose")
}
# Inside the function, the bru_verbose option is changed.
# Outside the function, the bru_verbose option is unchanged.
print(my_fun(TRUE))
print(bru_options_get("bru_verbose"))
print(my_fun(FALSE))
print(bru_options_get("bru_verbose"))
}
\seealso{
\code{\link[=bru_options_set]{bru_options_set()}}, \code{\link[=bru_options_default]{bru_options_default()}}, \code{\link[=bru_options_get]{bru_options_get()}}
}
\keyword{internal}
