% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltaIC.R
\name{deltaIC}
\alias{deltaIC}
\title{Summarise DIC and WAIC from \code{lgcp} objects.}
\usage{
deltaIC(..., criterion = "DIC")
}
\arguments{
\item{...}{Comma-separated objects inheriting from class \code{inla} and obtained
from a run of \code{INLA::inla()}, \code{\link[=bru]{bru()}} or \code{\link[=lgcp]{lgcp()}}}

\item{criterion}{If 'DIC', plots DIC differences; If 'WAIC', plots WAIC differences.}
}
\value{
A data frame with each row containing the model name, DIC, WAIC, deltaDIC, and
deltaWAIC.
}
\description{
Calculates DIC and WAIC differences and produces an ordered summary.
}
\examples{
\donttest{
# Generate some data
input.df <- data.frame(x = cos(1:10))
input.df <- within(
  input.df,
  y <- ceiling(5 + 2 * cos(1:10) + rnorm(10, mean = 0, sd = 0.1))
)

# Fit two models
fit <- bru(y ~ x, family = "gaussian", data = input.df)
fit2 <- bru(y ~ x, family = "Poisson", data = input.df)

# Compare DIC

deltaIC(fit, fit2)
}

}
