% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmesher_crs.R
\name{fm_spTransform}
\alias{fm_spTransform}
\alias{fm_spTransform.default}
\alias{fm_spTransform.SpatialPoints}
\alias{fm_spTransform.SpatialPointsDataFrame}
\alias{fm_spTransform.inla.mesh.lattice}
\alias{fm_spTransform.inla.mesh.segment}
\alias{fm_spTransform.inla.mesh}
\title{Handle transformation of various inla objects according to coordinate
reference systems of sp::CRS or INLA::inla.CRS class.}
\usage{
fm_spTransform(x, ...)

\method{fm_spTransform}{default}(x, crs0, crs1, passthrough = FALSE, ...)

\method{fm_spTransform}{SpatialPoints}(x, CRSobj, passthrough = FALSE, ...)

\method{fm_spTransform}{SpatialPointsDataFrame}(x, CRSobj, passthrough = FALSE, ...)

\method{fm_spTransform}{inla.mesh.lattice}(x, CRSobj, passthrough = FALSE, ...)

\method{fm_spTransform}{inla.mesh.segment}(x, CRSobj, passthrough = FALSE, ...)

\method{fm_spTransform}{inla.mesh}(x, CRSobj, passthrough = FALSE, ...)
}
\arguments{
\item{x}{The object that should be transformed from it's current CRS to a new CRS}

\item{\dots}{Potential additional arguments}

\item{crs0}{The source sp::CRS or inla.CRS object}

\item{crs1}{The target sp::CRS or inla.CRS object}

\item{passthrough}{Default is FALSE.
Setting to TRUE allows objects with no CRS information to be passed
through without transformation.}

\item{CRSobj}{The target sp::CRS or inla.CRS object}
}
\description{
Handle transformation of various inla objects according to coordinate
reference systems of sp::CRS or INLA::inla.CRS class.
}
\details{
The default method handles low level transformation of raw
coordinates.
}
\seealso{
\code{\link[=fm_CRS]{fm_CRS()}}
}
