% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.Poisson1_1D.R
\docType{data}
\name{Poisson1_1D}
\alias{Poisson1_1D}
\alias{lambda1_1D}
\alias{E_nc1}
\alias{pts1}
\alias{countdata1}
\title{1-Dimensional Homogeneous Poisson example.}
\format{
The data contain the following \code{R} objects:
\describe{
\item{\code{lambda1_1D}:}{ A function defining the intensity function of a
nonhomogeneous Poisson process. Note that this function is only defined on
the interval (0,55).}
\item{\code{E_nc1}}{ The expected counts of the gridded data.}
\item{\code{pts1}}{ The locations of the observed points (a data frame with one column, named \code{x}).}
\item{\code{countdata1}}{ A data frame with three columns, containing the count data:}
\describe{
\item{\code{x}}{ The grid cell midpoint.}
\item{\code{count}}{ The number of detections in the cell.}
\item{\code{exposure}}{ The width of the cell.}
}
}
}
\usage{
data(Poisson1_1D)
}
\description{
Point data and count data, together with intensity function and expected counts for
a homogeneous 1-dimensional Poisson process example.
}
\examples{
\donttest{
if (require("ggplot2", quietly = TRUE)) {
  data(Poisson1_1D)
  ggplot(countdata1) +
    geom_point(data = countdata1, aes(x = x, y = count), col = "blue") +
    ylim(0, max(countdata1$count)) +
    geom_point(data = pts1, aes(x = x), y = 0.2, shape = "|", cex = 4) +
    geom_point(
      data = countdata1, aes(x = x), y = 0, shape = "+",
      col = "blue", cex = 4
    ) +
    xlab(expression(bold(s))) +
    ylab("count")
}
}
}
