% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bru.inference.R, R/deprecated.R,
%   R/environment.R
\name{summary_bru}
\alias{summary_bru}
\alias{inlabru-deprecated}
\alias{iinla.getOption}
\alias{iinla.setOption}
\alias{init.tutorial}
\title{Deprecated functions in inlabru}
\usage{
summary_bru(object, ...)

iinla.getOption(name = NULL)

iinla.setOption(...)

init.tutorial()
}
\arguments{
\item{object}{An object obtained from a \code{\link[=bru]{bru()}} or \code{\link[=lgcp]{lgcp()}} call}

\item{\dots}{arguments passed on to other methods or ignored}

\item{name}{character; an option name}
}
\description{
These functions still attempt to do their job, but will be removed in a
future version.
}
\section{Functions}{
\itemize{
\item \code{summary_bru}: Old summary for an inlabru fit.

Takes a fitted \code{bru} object produced by \code{\link[=bru]{bru()}} or \code{\link[=lgcp]{lgcp()}} and creates
various summaries from it.

\item \code{iinla.getOption}: Use \code{bru_option_get} instead.

\item \code{iinla.setOption}: Use \code{bru_option_set} instead.

\item \code{init.tutorial}: Global setting for tutorial sessions.

Use \code{\link[=bru_options_set]{bru_options_set()}} to set specific
options instead instead.  In versions <= 2.1.15, this function set the INLA
integration strategy to "eb" to speed up calculations. This is normally not
needed since version 2.2.0, since the only the final iteration will use
other than "eb".
}}

\examples{
\dontrun{
# Note: Only run this if you want to change the inlabru options for this session

# Determine current bru defaults:
bo <- bru_options_get()

init.tutorial()

# Check if it worked:
bru_options_get("control.inla")
}

}
\author{
Fabian E. Bachl \email{bachlfab@gmail.com}
}
