#' Industrial Waste Ditch
#'
#' @description An industrial waste ditch located near the Naval Reactors Facility (NRF) in eastern Idaho.
#'   The NRF discharges its wastewater to this 1.65-mile-long waste ditch.
#'   The waste ditch was initially used in 1953 to dispose of non-radioactive, non-sewage industrial wastewater.
#'
#' @format A [simple feature](https://r-spatial.github.io/sf/articles/sf1.html) with fields:
#'   \describe{
#'     \item{`geometry`}{Sequence of points connected by straight, non-self-intersecting line pieces,
#'       one-dimensional geometry.}
#'   }
#'   See [`crs`] dataset for coordinate reference system information.
#'
#' @source A GeoJSON file of the industrial waste ditch was created by the U.S. Geological Survey
#'   [Idaho National Laboratory Project Office](https://www.usgs.gov/centers/idaho-water-science-center/science/idaho-national-laboratory-project-office)
#'
#' @keywords datasets
#'
#' @examples
#' print(iwd)
#'
#' plot(iwd, col = "blue")
"iwd"
