% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streams.R
\docType{data}
\name{streams}
\alias{streams}
\title{Rivers and Streams}
\format{
A \href{https://r-spatial.github.io/sf/articles/sf1.html}{simple feature} with fields:
\describe{
\item{\code{gnis_nm}}{GNIS name.}
\item{\code{id}}{Unique identifier.}
\item{\code{reach_cd}}{Reach code, a unique 14-digit code that identifies a
continuous piece of surface water with similar hydrologic characteristics.}
\item{\code{gnis_id}}{Geographic Names Information System (GNIS) identifier.}
\item{\code{feature_tp}}{USGS National Hydrography Dataset (NHD) feature type code.
The codes and their meanings are as follows:
"ArtificialPath" is a surrogate for general flow direction;
"CanalDitch" is an artificial open waterway constructed to transport water,
to irrigate or drain land, to connect two or more bodies of water,
or to serve as a waterway for watercraft;
"Connector"is a linear water feature that connects two or more waterbodies or
other linear water features; and
"StreamRiver" is a linear water feature that is a natural or man-made flowing body of water.}
\item{\code{resolution_cd}}{NHD reach resolution where "Medium" is one of the three resolutions
available for the NHD feature class. The Medium resolution is 1:100,000,
which means that one unit on the map represents 100,000 units on the ground.}
\item{\code{geometry}}{Sequence of points connected by straight, non-self-intersecting line pieces,
one-dimensional geometry.}
}
See \code{\link{crs}} dataset for coordinate reference system information.
}
\source{
Spatial line extract files obtained from the
U.S. Geological Survey (USGS) National Hydrography Dataset (NHD) Medium Resolution for Idaho,
released August 4, 2014. Which is part of the National Geospatial Technical Operations Center.
These extracts were cropped to eastern Idaho extent and unnecessary columns were removed.
}
\usage{
streams
}
\description{
Stream segments in the vicinity of Idaho National Laboratory (INL), eastern Idaho.
Surface water infiltrated to the eastern Snake River Plain aquifer
through river and streams. The chemical signatures in the water from the tributary
valleys define the background concentration in the groundwater in the western INL.
}
\examples{
print(streams)

plot(streams["id"], col = "blue")
}
\keyword{datasets}
