% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_erd.R
\name{make_erd}
\alias{make_erd}
\title{Create Entity Relationship Diagram}
\usage{
make_erd(dm, path = tempfile(fileext = ".svg"), overwrite = FALSE)
}
\arguments{
\item{dm}{'\link[dm:dm]{dm}' object.
Data model.}

\item{path}{'character' string.
File path to write the ERD.}

\item{overwrite}{'logical' flag.
Whether to overwrite an existing file.}
}
\value{
Invisibly returns the file path.
}
\description{
Create an Entity-Relationship Diagram (ERD) from a data model and save it to disk in SVG format.
Requires that the \pkg{dm}, \pkg{DiagrammeR}, \pkg{V8}, and \pkg{DiagrammeRsvg} packages are available.
}
\examples{
path <- make_dm() |> make_erd()

unlink(path)
}
\seealso{
\code{\link{make_dm}} function for creating a data model for the \pkg{inldata} package.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{internal}
