% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddScaleBar.R
\name{AddScaleBar}
\alias{AddScaleBar}
\title{Add Scale Bar to Plot}
\usage{
AddScaleBar(unit = NULL, conv.fact = NULL, vert.exag = NULL,
  longlat = FALSE, loc = "bottomleft", ...)
}
\arguments{
\item{unit}{'character' vector of length 1 or 2, value is recycled as necessary.
Label(s) describing the unit of measurement of scale distances, such as "METERS".}

\item{conv.fact}{'numeric' vector of length 1 or 2, value is recycled as necessary.
Conversion factor(s) for changing the unit of measurement for scale distances.
For example, if user coordinates of the plotting region are in meters,
specify \code{3.28084} to display scale distances in feet.
A dual-unit scale bar is created by specifying a second conversion factor.}

\item{vert.exag}{'logical' flag, 'numeric' vector, or 'character' vector.
Either a logical value indicating whether to include a vertical exaggeration label;
or a custom \emph{y/x} aspect ratio to include in this label.}

\item{longlat}{'logical' flag.
Whether user coordinates of the plotting region are in longitude and latitude;
if true, scale distances are in kilometers.
Note that scale distances are calculated at the maps latitude midpoint
using the Great Circle distance (WGS84 ellipsoid) method.}

\item{loc}{'character' string.
Position of the scale bar in the main plot region;
see \code{\link{GetInsetLocation}} function for keyword descriptions.}

\item{...}{Additional arguments to be passed to the \code{\link{GetInsetLocation}} function---used
to position the scale bar in the main plot region.}
}
\value{
Used for the side-effect of a scale bar drawn on the current graphics device.
}
\description{
Add a scale bar (also known as a rake scale) to a plot.
}
\examples{
plot(-100:100, -100:100, type = "n", xlab = "x in meters", ylab = "y in meters", asp = 2)
AddScaleBar()
AddScaleBar(loc = "center")
AddScaleBar(unit = "METERS", loc = "topleft", padin = 0.2)
AddScaleBar(unit = c("METERS", "FEET"), conv.fact = c(1, 3.28084),
            loc = "topright", padin = c(0.5, 0))
AddScaleBar(unit = c("METERS", "FEET"), conv.fact = c(1, 3.28084),
            vert.exag = TRUE, loc = "bottomright", inset = 0.1)

plot(c(-38.31, -35.5), c(40.96, 37.5), type = "n", xlab = "longitude", ylab = "latitude")
AddScaleBar(unit = "KILOMETERS", longlat = TRUE)
AddScaleBar(unit = "MILES", conv.fact = 0.621371, longlat = TRUE,
            loc = "topright", padin = c(0.4, 0))
AddScaleBar(unit = c("KILOMETERS", "MILES"), conv.fact = c(1, 0.621371),
            longlat = TRUE, loc = "topleft", inset = 0.05)

}
\seealso{
\code{\link{PlotMap}}, \code{\link{PlotCrossSection}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{hplot}
