% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_terms.R
\name{search_terms}
\alias{search_terms}
\title{Search Terms}
\usage{
search_terms(
  x,
  data = inlpubs::terms,
  ignore.case = TRUE,
  ...,
  low_freq = 1,
  high_freq = Inf,
  simplify = TRUE
)
}
\arguments{
\item{x}{'character' string.
Term searched for in the term-frequency data table.}

\item{data}{'term' and 'data.frame' class.
Term-frequency data table.
Defaults to using the term frequencies from the INLPO publications,
see \code{\link{terms}} dataset for details.}

\item{ignore.case}{'logical' flag.
Whether to ignore character case during pattern matching.}

\item{...}{Additional arguments passed to the \code{\link{grep}} function.}

\item{low_freq}{'numeric' number.
Lower frequency bound.}

\item{high_freq}{'numeric' number.
Upper frequency bound.}

\item{simplify}{'logical' flag.
Whether to return only the unique publication identifiers.}
}
\value{
A subset of the data table sorted by decreasing frequency.
}
\description{
Pattern matches a search term within the term-frequency data table.
}
\examples{
search_terms("mlms")

out <- search_terms("mlms", simplify = FALSE)
head(out)
}
\seealso{
\code{\link{mine_text}} function to perform a term frequency text analysis.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
