% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{filter_results}
\alias{filter_results}
\title{Filter optimization results}
\usage{
filter_results(
  results,
  run_ids,
  optimizer_ids,
  which_element,
  only_comparable,
  keep_empty = FALSE
)
}
\arguments{
\item{results}{A nested \code{list} of optimization results.
Each element corresponds to one optimization run.
It is either \code{list()} if the run has been removed or a \code{list}
of results for each optimizer.
The results for each optimizer is a \code{list}, the output of
\code{\link[optimizeR]{apply_optimizer}}.}

\item{run_ids}{A \code{vector} of indices. Selects the first layer of \code{results}.}

\item{optimizer_ids}{A \code{vector} of indices. Selects the second layer of \code{results}.}

\item{which_element}{A \code{character} (vector). Selects the third layer of \code{results}.}

\item{only_comparable}{See documentation of method \code{$results()} from \code{Nop} object.}

\item{keep_empty}{Set to \code{TRUE} (\code{FALSE}, the default) to keep (discard) empty
entries.}
}
\value{
A \code{list}.
}
\description{
This helper function filters optimization results.
}
\keyword{internal}
