#' Information on non-viral pathogens of insect hosts
#'
#' 
#' Non-viral parasite (protozoan, fungi, bacteria) occurrences on host species. The variables are 
#' as follows: 
#' 
#' 
#' \itemize{
#'   \item ERNnvp. EDWIP record number
#'   \item PathogenSpecies. Pathogen species
#'   \item Group. Pathogen group (e.g. Protozoa)
#'   \item HostSpecies. Host species examined
#'   \item HostStageTested. Host stage exposed to pathogen (e.g. Larvae, Nymph, Adult)
#'   \item HostTissueInfected. Host tissue infected
#'   \item FieldOrLab. Was this a field or lab tested association?
#'   \item Country. What country did the interaction occur in?
#'   \item IntermediateHost. Is there an intermediate host present?
#'   \item DateEntered. Date of initial data entry
#'   \item DateModified. Modification date of entry
#'   \item BiogeographicRegion. Biogeographic region (or some combination thereof)
#'   \item HostTaxID. Host NCBI ID number
#'   \item HostGenus. Host genus
#'   \item HostFamily. Host family
#'   \item HostOrder. Host order
#'   \item HostClass. Host class
#'   \item PathTaxID. Pathogen NCBI ID number
#'   \item PathGenus. Pathogen genus
#'   \item PathFamily. Pathogen family
#'   \item PathOrder. Pathogen order
#'   \item PathClass. Pathogen class
#'   \item PathKingdom. Pathogen kingdom
#'  }
#'
#' @docType data
#' @keywords datasets
#' @name nvpassoc
#' @usage data(nvpassoc)
#' @format A data.frame with 7164 observations

"nvpassoc"
