% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_obs.R
\name{n_obs}
\alias{n_obs}
\title{Get number of observations from a model}
\usage{
n_obs(x, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}
}
\value{
The number of observations used to fit the model, or \code{NULL} if
  this information is not available.
}
\description{
This method returns the number of observation that were used
  to fit the model, as numeric value.
}
\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
n_obs(m)

}
