% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_parameters_mixed.R
\name{get_parameters.glmm}
\alias{get_parameters.glmm}
\alias{get_parameters.coxme}
\alias{get_parameters.merMod}
\alias{get_parameters.glmmTMB}
\alias{get_parameters.glimML}
\title{Get model parameters from mixed models}
\usage{
\method{get_parameters}{glmm}(x, effects = c("all", "fixed", "random"), ...)

\method{get_parameters}{coxme}(x, effects = c("fixed", "random"), ...)

\method{get_parameters}{merMod}(x, effects = c("fixed", "random"), ...)

\method{get_parameters}{glmmTMB}(
  x,
  effects = c("fixed", "random"),
  component = c("all", "conditional", "zi", "zero_inflated", "dispersion"),
  ...
)

\method{get_parameters}{glimML}(x, effects = c("fixed", "random", "all"), ...)
}
\arguments{
\item{x}{A fitted model.}

\item{effects}{Should parameters for fixed effects, random effects
or both be returned? Only applies to mixed models. May be abbreviated.}

\item{...}{Currently not used.}

\item{component}{Which type of parameters to return, such as parameters for the
conditional model, the zero-inflated part of the model or the dispersion
term? Applies to models with zero-inflated and/or dispersion formula. Note
that the \emph{conditional} component is also called \emph{count} or \emph{mean}
component, depending on the model. There are three convenient shortcuts:
\code{component = "all"} returns all possible parameters.
If \code{component = "location"}, location parameters such as \code{conditional}
or \code{zero_inflated} are returned (everything that are fixed or random
effects - depending on the \code{effects} argument - but no auxiliary
parameters). For \code{component = "distributional"} (or \code{"auxiliary"}),
components like \code{sigma} or \code{dispersion} (and other auxiliary
parameters) are returned.}
}
\value{
If \code{effects = "fixed"}, a data frame with two columns: the
  parameter names and the related point estimates. If \code{effects =
  "random"}, a list of data frames with the random effects (as returned by
  \code{ranef()}), unless the random effects have the same simplified
  structure as fixed effects (e.g. for models from \pkg{MCMCglmm}).
}
\description{
Returns the coefficients from a model.
}
\details{
In most cases when models either return different "effects" (fixed,
random) or "components" (conditional, zero-inflated, ...), the arguments
\code{effects} and \code{component} can be used.
}
\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
get_parameters(m)
}
