% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_random_slopes.R
\name{find_random_slopes}
\alias{find_random_slopes}
\title{Find names of random slopes}
\usage{
find_random_slopes(x)
}
\arguments{
\item{x}{A fitted mixed model.}
}
\value{
A list of character vectors with the name(s) of the random slopes, or
   \code{NULL} if model has no random slopes. Depending on the model, the
   returned list has following elements:
   \itemize{
     \item \code{random}, the random slopes from the conditional part of model
     \item \code{zero_inflated_random}, the random slopes from the
     zero-inflation component of the model
   }
}
\description{
Return the name of the random slopes from mixed effects models.
}
\examples{
if (require("lme4")) {
  data(sleepstudy)
  m <- lmer(Reaction ~ Days + (1 + Days | Subject), data = sleepstudy)
  find_random_slopes(m)
}
}
