% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_transformation.R
\name{get_transformation}
\alias{get_transformation}
\title{Return function of transformed response variables}
\usage{
get_transformation(x)
}
\arguments{
\item{x}{A regression model.}
}
\value{
A list of two functions: \verb{$transformation}, the function that was used to
transform the response variable; \verb{$inverse}, the inverse-function of
\verb{$transformation} (can be used for "back-transformation"). If no
transformation was applied, both list-elements \verb{$transformation} and
\verb{$inverse} just return \code{function(x) x}.
}
\description{
This functions checks whether any transformation, such as log- or
exp-transforming, was applied to the response variable (dependent variable)
in a regression formula, and returns the related function that was used for
transformation.
}
\examples{
# identity, no transformation
model <- lm(Sepal.Length ~ Species, data = iris)
get_transformation(model)

# log-transformation
model <- lm(log(Sepal.Length) ~ Species, data = iris)
get_transformation(model)

# log-function
get_transformation(model)$transformation(.3)
log(.3)

# inverse function is exp()
get_transformation(model)$inverse(.3)
exp(.3)
}
