% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_inverse.R
\name{link_inverse}
\alias{link_inverse}
\title{Get link-inverse function from model object}
\usage{
link_inverse(x, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}
}
\value{
A function, describing the inverse-link function from a model-object.
   For multivariate-response models, a list of functions is returned.
}
\description{
Returns the link-inverse function from a model object.
}
\examples{
# example from ?stats::glm
counts <- c(18, 17, 15, 20, 10, 20, 25, 13, 12)
outcome <- gl(3, 1, 9)
treatment <- gl(3, 3)
m <- glm(counts ~ outcome + treatment, family = poisson())

link_inverse(m)(.3)
# same as
exp(.3)
}
