\name{eqtime}
\alias{eqtime}

\title{ Equation of time }
\description{ Computes the equation of time for a given Julian Day. }
\usage{
eqtime(jd)
}

\arguments{
  \item{jd}{Julian Day.}
}

\value{Equation of time in minutes. }

\references{
\url{http://www.esrl.noaa.gov/gmd/grad/solcalc/calcdetails.html}

Meeus, J. 1999.  \emph{Astronomical Algorithms}. Willmann-Bell, Richmond, Virginia, USA.

Reda, I. and Andreas, A. 2003. \emph{Solar Position Algorithm for Solar Radiation Applications}. 55 pp.; 
NREL Report No. TP-560-34302, Revised January 2008.
\url{http://www.nrel.gov/docs/fy08osti/34302.pdf}
}
\author{Javier G. Corripio}


\examples{
# plot the equation of time for 2013 at daily intervals
jdays=seq(ISOdate(2013,1,1),ISOdate(2013,12,31),by='day')
jd=JD(jdays)
plot(eqtime(jd))
abline(h=0,col=8)

# Analema
plot(eqtime(jd),declination(jd))

# Analema from Greenwich Observatory
latGwch=51.4791
x = 180+eqtime(jd)*15/60
y = 90-latGwch+declination(jd)
plot(x,y,ylim=c(0,90),xlab=expression(paste('Azimuth (',degree,')')),
	ylab=expression(paste('Elevation (',degree,')')))

## plot the solstices and equinoxes (nearest day, see ?declination for more precision)
decl=declination(jd)
wintersolstice=which(decl==min(decl))
summersolstice=which(decl==max(decl))
## spring equinox: when declination becomes zero in the first part of the year
springeqx=uniroot(declination,jd[c(1,180)])$root
springeqx=daydoy(JD(springeqx,inv=TRUE))
autumeqx=uniroot(declination,jd[c(180,360)])$root
autumeqx=daydoy(JD(autumeqx,inv=TRUE))
nodeseqx=c(springeqx,summersolstice,autumeqx,wintersolstice)
points(x[nodeseqx],y[nodeseqx],pch=19,col=3)
abline(h=c(90-latGwch,90-latGwch+max(decl),90-latGwch+min(decl)),col=8)

}

