% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_package_compile.R
\name{stan_package_compile}
\alias{stan_package_compile}
\title{Compile the Stan models in an R package.}
\usage{
stan_package_compile(
  models = instantiate::stan_package_model_files(),
  cmdstan_install = Sys.getenv("CMDSTAN_INSTALL", unset = ""),
  verbose = TRUE,
  quiet = FALSE,
  pedantic = FALSE,
  include_paths = NULL,
  user_header = NULL,
  cpp_options = list(),
  stanc_options = list(),
  force_recompile = getOption("cmdstanr_force_recompile", default = FALSE),
  threads = FALSE,
  ...
)
}
\arguments{
\item{models}{Character vector of file paths to Stan model source code
files. Defaults to the Stan files in \verb{./src/stan/}
because all the Stan model files must live in the \verb{src/stan/} folder
for an R package built with \code{instantiate}.}

\item{cmdstan_install}{Character of length 1, how to look for an installed
copy of CmdStan. See \url{https://wlandau.github.io/instantiate/} for details.
Choices:
\enumerate{
\item \code{""} (default): look at the original value that the \code{CMDSTAN_INSTALL}
environment variable contained when \code{instantiate} at the time
when it was installed.
If it was \code{"implicit"} or \code{"fixed"}, then choose
the corresponding option below. Otherwise, default to \code{"implicit"}.
\item \code{"implicit"}: Let the \code{cmdstanr::cmdstan_path()} decide where
to look for CmdStan. As explained in the \code{cmdstanr} documentation,
the output of \code{cmdstanr::cmdstan_path()} depends
on the current value of the \code{CMDSTAN} environment variable.
The \code{cmdstanr} package must be installed. If it
is not installed, then \code{stan_cmdstan_path()}
returns the empty string \code{""}.
\item \code{"fixed"}: Use the path to CmdStan that was originally
contained in \code{Sys.getenv("CMDSTAN")} at the time when \code{instantiate}
was installed.
}}

\item{verbose}{Logical of length 1, whether to set the
\code{cmdstanr_verbose} global option to print more compiler messages
than usual.}

\item{quiet}{Argument to \code{cmdstanr::cmdstan_model()} to control compilation.}

\item{pedantic}{Logical of length 1, whether to activate pedantic
mode when compiling the Stan models. See the \code{cmdstanr} documentation
for details.}

\item{include_paths}{Argument to \code{cmdstanr::cmdstan_model()}
to control model compilation.}

\item{user_header}{Argument to \code{cmdstanr::cmdstan_model()}
to control model compilation.}

\item{cpp_options}{Argument to \code{cmdstanr::cmdstan_model()}
to control model compilation.}

\item{stanc_options}{Argument to \code{cmdstanr::cmdstan_model()}
to model control compilation.}

\item{force_recompile}{Argument to \code{cmdstanr::cmdstan_model()}
to model control compilation.}

\item{threads}{Argument to \code{cmdstanr::cmdstan_model()}
to model control compilation.}

\item{...}{Other named arguments to \code{cmdstanr::cmdstan_model()}.}
}
\value{
\code{NULL} (invisibly). Called for its side effects.
}
\description{
Compile all Stan models in a directory, usually in a package.
}
\details{
If building a package using \code{instantiate}, all Stan model files
must live in a folder called \verb{src/stan/} in the package source
directory.
}
\examples{
if (identical(Sys.getenv("INSTANTIATE_EXAMPLES"), "true")) {
path <- tempfile()
stan_package_create(path = path)
stan_package_configure(path = path)
models <- stan_package_model_files(path)
list.files(file.path(path, "inst", "stan"))
stan_package_compile(models)
list.files(file.path(path, "inst", "stan"))
}
}
\seealso{
Other packages: 
\code{\link{stan_cmdstan_path}()},
\code{\link{stan_package_clean}()},
\code{\link{stan_package_configure}()},
\code{\link{stan_package_model_files}()}
}
\concept{packages}
