% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_4loss_ratio_plot.R
\name{autoplot.univ_lossratio}
\alias{autoplot.univ_lossratio}
\title{Automatically create a ggplot for objects obtained from univariate_loss_ratio()}
\usage{
\method{autoplot}{univ_lossratio}(
  x,
  background = TRUE,
  labels = TRUE,
  sort = FALSE,
  dec.mark = ",",
  color = "dodgerblue",
  color_bg = "#E7B800"
)
}
\arguments{
\item{x}{univ_lossratio object produced by \code{univariate_loss_ratio()}}

\item{background}{show exposure as a histogram (default is TRUE)}

\item{labels}{show labels with the exposure (default is TRUE)}

\item{sort}{sort (or order) risk factor into descending order by exposure (default is FALSE)}

\item{dec.mark}{control the format of the decimal point, as well as the mark between intervals before the decimal point, choose either "," (default) or "."}

\item{color}{change the color of the points and line ("dodgerblue" is default)}

\item{color_bg}{change the color of the histogram ("#E7B800" is default)}
}
\value{
a ggplot2 object
}
\description{
Takes an object produced by \code{univariate_loss_ratio()}, and plots the loss ratio.
}
\examples{
library(ggplot2)
x <- univariate_loss_ratio(MTPL2, x = area, severity = amount, premium = premium)
autoplot(x)

}
