% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_tariff_classes.R
\name{autoplot.constructtariffclasses}
\alias{autoplot.constructtariffclasses}
\title{Automatically create a ggplot for objects obtained from construct_tariff_classes()}
\usage{
\method{autoplot}{constructtariffclasses}(
  object,
  conf_int = FALSE,
  color_gam = "steelblue",
  show_observations = FALSE,
  color_splits = "grey50",
  size_points = 1,
  color_points = "black",
  rotate_labels = FALSE,
  remove_outliers = NULL,
  ...
)
}
\arguments{
\item{object}{constructtariffclasses object produced by \code{construct_tariff_classes}}

\item{conf_int}{determines whether 95\% confidence intervals will be plotted. The default is \code{conf_int = FALSE}}

\item{color_gam}{a color can be specified either by name (e.g.: "red") or by hexadecimal code (e.g. : "#FF1234") (default is "steelblue")}

\item{show_observations}{add observed frequency/severity points for each level of the variable for which tariff classes are constructed}

\item{color_splits}{change the color of the splits in the graph ("grey50" is default)}

\item{size_points}{size for points (1 is default)}

\item{color_points}{change the color of the points in the graph ("black" is default)}

\item{rotate_labels}{rotate x-labels 45 degrees (this might be helpful for overlapping x-labels)}

\item{remove_outliers}{do not show observations above this number in the plot. This might be helpful for outliers.}

\item{...}{other plotting parameters to affect the plot}
}
\value{
a ggplot object
}
\description{
Takes an object produced by \code{construct_tariff_classes()}, and plots the fitted GAM.
In addition the constructed tariff classes are shown.
}
\examples{
\dontrun{
library(ggplot2)
library(dplyr)
fit_gam(MTPL, nclaims = nclaims, x = age_policyholder, exposure = exposure) \%>\%
   construct_tariff_classes(.) \%>\%
   autoplot(., show_observations = TRUE)
}

}
\author{
Martin Haringa
}
