% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataprep.R
\name{dataprep}
\alias{dataprep}
\title{Data manipulation}
\usage{
dataprep(data, ID, time, event, Z)
}
\arguments{
\item{data}{a data frame that includes the variables named in the \code{ID}, \code{time}, \code{event}, and \code{z} arguments}

\item{ID}{a variable indicating individuals' ID}

\item{time}{a variable indicating observed time points}

\item{event}{a vector of event indicator. If an observation is righ-censored, \code{event = 0}; otherwise, \code{event = 1} or \code{event = 2}, where \code{1} represents the first cause of failure, and \code{2} represents the second cause of failure. The current version of package only allows two causes of failure.}

\item{Z}{a vector of variables indicating name of covariates}
}
\value{
a data frame
}
\description{
The function \code{dataprep} reshapes data from a long format to a ready-to-use format to be used directly in the function \code{ciregic}.
}
\details{
The function \code{dataprep} provides a ready-to-use data format that can be directly used in the function \code{ciregic}. The returned data frame consists of \code{id}, \code{v}, \code{u}, \code{c}, and covariates as columns. The \code{v} and \code{u} indicate time window with the last observation time before the event and the first observation after the event. The \code{c} represents a type of event, for example, \code{c = 1} for the first cause of failure, \code{c = 2} for the second cause of failure, and \code{c = 0} for the right-censored. Individuals who have only one time record with right-censored event will be omitted because its time interval is \code{(0, Inf)}, and the lower bound \code{v} will be replaced by zero, for example \code{(0, v]}, if individuals are not right-censored and have only one time record.
}
\examples{
library(intccr)
dataprep(data = longdata, ID = "id", time = "t", event = "c", Z = c("z1", "z2"))

}
\author{
Giorgos Bakoyannis, \email{gbakogia at iu dot edu}

Jun Park, \email{jp84 at iu dot edu}
}
\keyword{dataprep}
