% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intcure.r
\name{summary.intcure}
\alias{summary.intcure}
\title{Summary of fitted mixture cure models with random effects}
\usage{
\method{summary}{intcure}(object, ...)
}
\arguments{
\item{object}{an \code{intcure} object obtained from \code{intcure}}

\item{...}{inherited but not used here}
}
\value{
An object of class \code{summary.intcure} is returned.
It is a list that includes all the components of class \code{intcure} plus an
additional component \code{statistics}, which is a list of following components:
\item{bt}{a matrix with column \code{Estimate}, \code{Stderr}, \code{zvalue},
and \code{pvalue} for the estimated value of beta in the latency model}
\item{gm}{a matrix with column \code{Estimate}, \code{Stderr}, \code{zvalue},
and \code{pvalue} for the estimated value of gamma in the incidence model}
\item{basepara}{a matrix with column \code{Estimate}, \code{Stderr},
\code{zvalue}, and \code{pvalue} for the estimated value of the parameters
in the baseline distribution}
\item{sigma}{a matrix with column \code{Estimate} and \code{Stderr} for the
random effects in the model}
}
\description{
It calculates standard errors, z-values, and p-values of estimates from a fitted mixture cure model with random effects
}
\examples{
data(bmtfit)
summary(bmtfit)
}
\seealso{
\code{\link{intcure}}
}
\author{
Yingwei Peng
}
