% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interfacer.R
\name{ireturn}
\alias{ireturn}
\title{Check a return parameter from a function}
\usage{
ireturn(df, iface, .prune = FALSE)
}
\arguments{
\item{df}{a dataframe - if missing then the first parameter of the calling
function is assumed to be a dataframe.}

\item{iface}{the interface specification that \code{df} should conform to.}

\item{.prune}{get rid of excess columns that are not in the spec.}
}
\value{
a dataframe based on \code{df} with validity checks passed,
data-types coerced, and correct grouping applied to conform to \code{iface}
}
\description{
This is intended to be used within a function to check the validity of a data
frame being returned from a function against an \code{ispec} which is provided.
}
\examples{

input = iface(col_in = integer ~ "an integer column" )
output = iface(col_out = integer ~ "an integer column" )

x = function(df = input, ...) {
  df = ivalidate(...)
  tmp = df \%>\% dplyr::rename(col_out = col_in)
  ireturn(tmp, output)
}
x(tibble::tibble(col_in = c(1,2,3)))
output

}
\concept{interface}
