% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yupana_import_smr.R
\name{yupana_import_smr}
\alias{yupana_import_smr}
\title{Import information from data summary}
\usage{
yupana_import_smr(data)
}
\arguments{
\item{data}{Summary information with options}
}
\value{
list
}
\description{
Graph summary data
}
\examples{

\dontrun{

library(inti)
library(gsheet)

url <- paste0("https://docs.google.com/spreadsheets/d/"
              , "15r7ZwcZZHbEgltlF6gSFvCTFA-CFzVBWwg3mFlRyKPs/edit#gid=1948849836")
# browseURL(url)

data <- gsheet2tbl(url)

info <- yupana_import_smr(data)

info
 
plot_smr(data = info$data
         , type = info$type
         , x = info$x
         , y = info$y
         , group = info$group
         , ylimits = info$ylimits
         , color = info$color
         )

}

}
