% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tarpuy_plotdesign.R
\name{tarpuy_plotdesign}
\alias{tarpuy_plotdesign}
\title{Fieldbook plot experimental designs}
\usage{
tarpuy_plotdesign(
  data,
  factor = NA,
  fill = "plots",
  xlab = NULL,
  ylab = NULL,
  glab = NULL
)
}
\arguments{
\item{data}{Experimental design data frame with the factors and level. See
examples.}

\item{factor}{Vector with the name of the columns with the factors.}

\item{fill}{Value for fill the experimental units (default = "plots").}

\item{xlab}{Title for x axis.}

\item{ylab}{Title for y axis.}

\item{glab}{Title for group axis.}
}
\value{
plot
}
\description{
Plot fieldbook sketch designs based in experimental design
}
\details{
The function allows to plot the experimental design according the
  field experiment design.
}
\examples{

\dontrun{

library(inti)
library(gsheet)

url <- paste0("https://docs.google.com/spreadsheets/d/"
              , "1grAv_2po804pPGg9nj1o5nli01IcEGvSevDruq_ssHk/edit#gid=1807254932")
# browseURL(url)

fb <- gsheet2tbl(url) 

dsg <- fb \%>\% tarpuy_design() 

dsg

dsg \%>\% str()

dsg \%>\% 
  tarpuy_plotdesign()

}
}
